package gov.va.vinci.dart.db;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.Event;
import gov.va.vinci.dart.biz.EventSummary;
import gov.va.vinci.dart.biz.EventType;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.service.DartObjectFactory;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class TestEventDAO extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {
 
	    
		List<DartRequest> drList = DartObjectFactory.getInstance().getDartRequestDAO().listAll();
		Assert.assertNotNull(drList);
		Assert.assertTrue(drList.size() > 0);
		
		DartRequest request = drList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		Assert.assertNotNull(request.getActivity());
		Assert.assertTrue(request.getActivity().getId() > 0);

		Event event = Event.create(EventType.INITIATE_REQUEST, request, "DNS");
		Assert.assertNotNull(event);
		Assert.assertTrue(event.getId() > 0);

		Group group = DartObjectFactory.getInstance().getGroupDAO().findById(1);
		Assert.assertNotNull(group);
		Assert.assertTrue(group.getId() > 0);

		Event event2 = Event.create("Event Name", "Event Description", EventType.INITIATE_REQUEST, group, true, request, "DNS");
		Assert.assertNotNull(event2);
		Assert.assertTrue(event2.getId() > 0);

		List<Event> eList = DartObjectFactory.getInstance().getEventDAO().listByActivityId(request.getActivity().getId());
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertTrue(eList.contains(event));
		
		
		eList = DartObjectFactory.getInstance().getEventDAO().listByEventTypeAndRequestId(EventType.INITIATE_REQUEST.getId(), request.getId());
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertTrue(eList.contains(event));

		eList = DartObjectFactory.getInstance().getEventDAO().listByActivityIdAndGroupId(request.getActivity().getId(), group.getId());
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));
		
		eList = DartObjectFactory.getInstance().getEventDAO().listByRequestIdAndGroupId(request.getId(), group.getId());
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));

		eList = DartObjectFactory.getInstance().getEventDAO().listByActivityIdAndGroupOrder(request.getActivity().getId(), group.getId(), false);
		Assert.assertNotNull(eList);
		Assert.assertFalse(eList.contains(event));
		Assert.assertFalse(eList.contains(event2));

		eList = DartObjectFactory.getInstance().getEventDAO().listByActivityIdAndGroupOrder(request.getActivity().getId(), group.getId(), true);
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));

		eList = DartObjectFactory.getInstance().getEventDAO().listByRequestIdAndGroupOrder(request.getId(), group.getId(), false);
		Assert.assertNotNull(eList);
		Assert.assertFalse(eList.size() > 0);

		eList = DartObjectFactory.getInstance().getEventDAO().listByRequestIdAndGroupOrder(request.getId(), group.getId(), true);
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));

		eList = DartObjectFactory.getInstance().getEventDAO().listByEventTypeAndActivityIdAndGroupId(EventType.INITIATE_REQUEST.getId(), request.getActivity().getId(), group.getId());
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));
		

		eList = DartObjectFactory.getInstance().getEventDAO().listByEventTypeAndActivityIdAndGroupOrder(EventType.INITIATE_REQUEST.getId(), request.getActivity().getId(), group.getId(), false);
		Assert.assertNotNull(eList);
		Assert.assertFalse(eList.size() > 0);

		eList = DartObjectFactory.getInstance().getEventDAO().listByEventTypeAndActivityIdAndGroupOrder(EventType.INITIATE_REQUEST.getId(), request.getActivity().getId(), group.getId(), true);
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));

		eList = DartObjectFactory.getInstance().getEventDAO().listByEventTypeAndRequestIdAndGroupOrder(EventType.INITIATE_REQUEST.getId(), request.getId(), group.getId(), false);
		Assert.assertNotNull(eList);
		Assert.assertFalse(eList.size() > 0);

		eList = DartObjectFactory.getInstance().getEventDAO().listByEventTypeAndRequestIdAndGroupOrder(EventType.INITIATE_REQUEST.getId(), request.getId(), group.getId(), true);
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));

		eList = DartObjectFactory.getInstance().getEventDAO().listByGroup(group.getId());
		Assert.assertNotNull(eList);
		Assert.assertTrue(eList.size() > 0);
		Assert.assertFalse(eList.contains(event));
		Assert.assertTrue(eList.contains(event2));

		List<EventSummary> esList = DartObjectFactory.getInstance().getEventDAO().listSummaryByRequestId(request.getId());
		Assert.assertNotNull(esList);
		Assert.assertTrue(esList.size() > 0);

		esList = DartObjectFactory.getInstance().getEventDAO().listSummaryByActivityId(request.getActivity().getId());
		Assert.assertNotNull(esList);
		Assert.assertTrue(esList.size() > 0);

	}
}
